#
#
#	flat_1D.cl: flats spectra in 1D!
#       TO BE USED AFTER running apflatten, apedit and doecslit
#	on flats and data!!!!!
#
##############################################################

procedure flat_1D (iinput_flat,jinput_list,lampname,trac1d_fl,trac1d_file,inter1d,order1d_fl,dir1d,del1d)

string iinput_flat     {prompt='2D reduced flat image (input in split_file) to be used:'} 
string	jinput_list    {prompt='List of giano data (input in copy_file) or single image:'}
string lampname 	{prompt='Reduced calibration lamp list (input in copy_file) or single image:'}
bool trac1d_fl=yes       {prompt='Use traces from flats?'}
string trac1d_file       {prompt='Reference frame for traces?'}
bool inter1d=yes  	 {prompt='Interactively follow fit to 1D spectra?'} 
bool order1d_fl=yes       {prompt='Normalise flat to a constant value (yes) or fit a polinomial (no)?'}
string dir1d='database'   {prompt='Directory holding the aperture files (default database)'}
bool del1d=no             {prompt='Delete 1D normalised flats?'}

begin
int i,mm
int ki
string s
			



	                imcopy(input=iinput_flat,output="tmp_flat_corr.fits")
       hedit (images="tmp_flat_corr.fits",fields="ccdproc",value="DOSLIT",add=yes,update=yes,verify=no, show=no)
			print("tmp_flat_corr",>>"tmp_aux_fl_file.txt")
                        copy_file(anysub=no,inlist="",inlamp="tmp_aux_fl_file.txt",mode="h")
			delete("tmp_aux_fl_file.txt")
			imdelete(images="tmp_flat_corr.fits")
		if(trac1d_fl==yes){
                mm=strlen(iinput_flat)
                  if(substr(iinput_flat,(mm-4),mm)==".fits"){
                    iinput_flat=substr(input_flat,1,(mm-5))}
		trac1d_file=iinput_flat}
				else
                              {
               mm=strlen(trac1d_file)
                  if(substr(trac1d_file,(mm-4),mm)==".fits"){
                    trac1d_file=substr(trac1d_file,1,(mm-5))}
				}
                  apedit(input="tmp_flat_corr_lowest",apertur=1-50,referen=trac1d_file//"_lowest",interac=no,find=no,recenter=no,resize=no,edit=no,line=INDEF,nsum=10,width=4,radius=10,mode="h")
                  apedit(input="tmp_flat_corr_middown",apertur=1-50,referen=trac1d_file//"_middown",interac=no,find=no,recenter=no,resize=no,edit=no,line=INDEF,nsum=10,width=4,radius=10,mode="h")
                  apedit(input="tmp_flat_corr_midup",apertur=1-50,referen=trac1d_file//"_midup",interac=no,find=no,recenter=no,resize=no,edit=no,line=INDEF,nsum=10,width=4,radius=10,mode="h")
                  apedit(input="tmp_flat_corr_topmost",apertur=1-50,referen=trac1d_file//"_topmost",interac=no,find=no,recenter=no,resize=no,edit=no,line=INDEF,nsum=10,width=4,radius=10,mode="h")
	#NOW extracts 1D flats, one per track!
         doecslit.width=5
         doecslit.extcor=no
         doecslit.fluxcal=no
         doecslit.resize=no
         doecslit.clean=no
         doecslit.trace=no
         doecslit.trace=no
         doecslit.splot=no
         doecslit.redo=no
         doecslit.update=no
         doecslit.quicklo=no
                sparams.b_funct="legendre"
                sparams.b_order=2
                sparams.b_naver=-100
                sparams.b_niter=3
                sparams.b_low=1
                sparams.b_high=1
                sparams.thresho=10
                sparams.coordli="gianot$U_Ne_Ar_lines_list_cl.dat"
                sparams.match=0.1
                sparams.fwidth=6
                sparams.cradius=10
                sparams.i_funct="legendre"
                sparams.i_xorde=4
                sparams.i_yorde=4
                sparams.i_niter=3
                sparams.i_low=3
                sparams.i_high=3
                sparams.refit=yes
                sparams.select="average"
                sparams.sort="jd"
                sparams.group="ljd"
                sparams.time=no
                sparams.lineari=yes
                sparams.log=no
                sparams.flux=yes
		#check whether lampname file or list
		mm=strlen(lampname)
                  if(substr(lampname,(mm-4),mm)==".fits" || access(lampname//".fits")){
                  if(substr(lampname,(mm-4),mm)==".fits"){
                    lampname=substr(lampname,1,(mm-5))}
                doecslit(objects="tmp_flat_corr_lowest",apref=trac1d_file//"_lowest",arcs=lampname//"_lowest",norders=50,dispcor=yes,backgrou="no",splot=no,batch=no,mode="h")
                doecslit(objects="tmp_flat_corr_middown",apref=trac1d_file//"_middown",arcs=lampname//"_middown",norders=50,dispcor=yes,backgrou="no",splot=no,batch=no,mode="h")
                doecslit(objects="tmp_flat_corr_midup",apref=trac1d_file//"_midup",arcs=lampname//"_midup",norders=50,dispcor=yes,backgrou="no",splot=no,batch=no,mode="h")
                doecslit(objects="tmp_flat_corr_topmost",apref=trac1d_file//"_topmost",arcs=lampname//"_topmost",norders=50,dispcor=yes,backgrou="no",splot=no,batch=no,mode="h")
			}
				else
				{
		if(substr(lampname,1,1)=="@"){
		mm=strlen(lampname)
		lampname=substr(lampname,2,mm)
				}
   		list=lampname
                while(fscan(list,s)!=EOF){
		ki=strlen(s)
                if(substr(s,(ki-4),ki)==".fits"){
		s=substr(s,1,(ki-5))
				}
		print(s//"_lowest",>>lampname//"_lowest")
		print(s//"_middown",>>lampname//"_middown")
		print(s//"_midup",>>lampname//"_midup")
		print(s//"_topmost",>>lampname//"_topmost")
			}
                doecslit(objects="tmp_flat_corr_lowest",apref=trac1d_file//"_lowest",arcs="@"//lampname//"_lowest",norders=50,dispcor=yes,backgrou="no",splot=no,batch=no,mode="h")
                doecslit(objects="tmp_flat_corr_middown",apref=trac1d_file//"_middown",arcs="@"//lampname//"_middown",norders=50,dispcor=yes,backgrou="no",splot=no,batch=no,mode="h")
                doecslit(objects="tmp_flat_corr_midup",apref=trac1d_file//"_midup",arcs="@"//lampname//"_midup",norders=50,dispcor=yes,backgrou="no",splot=no,batch=no,mode="h")
                doecslit(objects="tmp_flat_corr_topmost",apref=trac1d_file//"_topmost",arcs="@"//lampname//"_topmost",norders=50,dispcor=yes,backgrou="no",splot=no,batch=no,mode="h")
		delete(lampname//"_lowest")
		delete(lampname//"_middown")
		delete(lampname//"_midup")
		delete(lampname//"_topmost")
			}
# Now, having the spectra we need to fit them for normalisation!
	if(order1d_fl==yes){
	continuum(input="tmp_flat_corr_lowest.ec.fits",output="tmp_flat_corr_lowest_nrm.ec.fits",lines="*",bands=1,type="ratio",replace=no,wavescale=yes,listonl=no,interac=inter1d,naverag=1,functio="chebyshev",order=1,low_rej=3,high_rej=3,niterat=3,mode="h")
	continuum(input="tmp_flat_corr_middown.ec.fits",output="tmp_flat_corr_middown_nrm.ec.fits",lines="*",bands=1,type="ratio",replace=no,wavescale=yes,listonl=no,interac=inter1d,naverag=1,functio="chebyshev",order=1,low_rej=3,high_rej=3,niterat=3,mode="h")
	continuum(input="tmp_flat_corr_midup.ec.fits",output="tmp_flat_corr_midup_nrm.ec.fits",lines="*",bands=1,type="ratio",replace=no,wavescale=yes,listonl=no,interac=inter1d,naverag=1,functio="chebyshev",order=1,low_rej=3,high_rej=3,niterat=3,mode="h")
	continuum(input="tmp_flat_corr_topmost.ec.fits",output="tmp_flat_corr_topmost_nrm.ec.fits",lines="*",bands=1,type="ratio",replace=no,wavescale=yes,listonl=no,interac=inter1d,naverag=1,functio="chebyshev",order=1,low_rej=3,high_rej=3,niterat=3,mode="h")
	imdelete("tmp_flat_corr_lowest")
	imdelete("tmp_flat_corr_middown")
	imdelete("tmp_flat_corr_midup")
	imdelete("tmp_flat_corr_topmost")
	imdelete("tmp_flat_corr_lowest.ec")
	imdelete("tmp_flat_corr_middown.ec")
	imdelete("tmp_flat_corr_midup.ec")
	imdelete("tmp_flat_corr_topmost.ec")
				}
			else
		#i. e., fit a polynomial and normalise
				{
	continuum(input="tmp_flat_corr_lowest.ec.fits",output="tmp_flat_corr_lowest_nrm.ec.fits",lines="*",bands=1,type="ratio",replace=no,wavescale=yes,listonl=no,interac=inter1d,naverag=1,functio="spline3",order=5,low_rej=3,high_rej=3,niterat=3,mode="h")
	continuum(input="tmp_flat_corr_middown.ec.fits",output="tmp_flat_corr_middown_nrm.ec.fits",lines="*",bands=1,type="ratio",replace=no,wavescale=yes,listonl=no,interac=inter1d,naverag=1,functio="spline3",order=5,low_rej=3,high_rej=3,niterat=3,mode="h")
	continuum(input="tmp_flat_corr_midup.ec.fits",output="tmp_flat_corr_midup_nrm.ec.fits",lines="*",bands=1,type="ratio",replace=no,wavescale=yes,listonl=no,interac=inter1d,naverag=1,functio="spline3",order=5,low_rej=3,high_rej=3,niterat=3,mode="h")
	continuum(input="tmp_flat_corr_topmost.ec.fits",output="tmp_flat_corr_topmost_nrm.ec.fits",lines="*",bands=1,type="ratio",replace=no,wavescale=yes,listonl=no,interac=inter1d,naverag=1,functio="spline3",order=5,low_rej=3,high_rej=3,niterat=3,mode="h")
	imdelete("tmp_flat_corr_lowest")
	imdelete("tmp_flat_corr_middown")
	imdelete("tmp_flat_corr_midup")
	imdelete("tmp_flat_corr_topmost")
	imdelete("tmp_flat_corr_lowest.ec")
	imdelete("tmp_flat_corr_middown.ec")
	imdelete("tmp_flat_corr_midup.ec")
	imdelete("tmp_flat_corr_topmost.ec")
				}
		#finally, normalisation!
		if(jinput_list != " "){
		mm=strlen(jinput_list)
                  if(substr(jinput_list,(mm-4),mm)==".fits" || access(jinput_list//".fits")){
                  if(substr(jinput_list,(mm-4),mm)==".fits"){
                    jinput_list=substr(jinput_list,1,(mm-5))}
	if(access(jinput_list//"_lowest_fl.ec.fits")){print("FLATTED SPECTRUM ",jinput_list//"_lowest_fl.ec"," ALREADY EXISTS, IT IS NOT OVERWRITTEN!")}	
				else
				 {	
	sarith(input1=jinput_list//"_lowest.ec",op="/",input2="tmp_flat_corr_lowest_nrm.ec",output=jinput_list//"_lowest_fl.ec",w1=INDEF,w2=INDEF,format="multispec",renumbe=no,offset=0,rebin=yes,errval=0,verbose=no,mode="h")	
				 }
	if(access(jinput_list//"_middown_fl.ec.fits")){print("FLATTED SPECTRUM ",jinput_list//"_middown_fl.ec"," ALREADY EXISTS, IT IS NOT OVERWRITTEN!")}	
				else
				 {	
	sarith(input1=jinput_list//"_middown.ec",op="/",input2="tmp_flat_corr_middown_nrm.ec",output=jinput_list//"_middown_fl.ec",w1=INDEF,w2=INDEF,format="multispec",renumbe=no,offset=0,rebin=yes,errval=0,verbose=no,mode="h")	
				 }
	if(access(jinput_list//"_midup_fl.ec.fits")){print("FLATTED SPECTRUM ",jinput_list//"_midup_fl.ec"," ALREADY EXISTS, IT IS NOT OVERWRITTEN!")}	
				else
				 {	
	sarith(input1=jinput_list//"_midup.ec",op="/",input2="tmp_flat_corr_midup_nrm.ec",output=jinput_list//"_midup_fl.ec",w1=INDEF,w2=INDEF,format="multispec",renumbe=no,offset=0,rebin=yes,errval=0,verbose=no,mode="h")	
				 }
	if(access(jinput_list//"_topmost_fl.ec.fits")){print("FLATTED SPECTRUM ",jinput_list//"_topmost_fl.ec"," ALREADY EXISTS, IT IS NOT OVERWRITTEN!")}	
				else
				 {	
	sarith(input1=jinput_list//"_topmost.ec",op="/",input2="tmp_flat_corr_topmost_nrm.ec",output=jinput_list//"_topmost_fl.ec",w1=INDEF,w2=INDEF,format="multispec",renumbe=no,offset=0,rebin=yes,errval=0,verbose=no,mode="h")	
				 }
				 }
					else
					{
		list=jinput_list
		if(substr(jinput_list,1,1)=="@"){
		mm=strlen(jinput_list)
		list=substr(jinput_list,2,mm)
				}
                while(fscan(list,s)!=EOF){
                mm=strlen(s)
                  if(substr(s,(mm-4),mm)==".fits"){
                    s=substr(s,1,(mm-5))}
	if(access(s//"_lowest_fl.ec.fits")){print("FLATTED SPECTRUM ",s//"_lowest_fl.ec"," ALREADY EXISTS, IT IS NOT OVERWRITTEN!")}	
				else
				 {	
	sarith(input1=s//"_lowest.ec",op="/",input2="tmp_flat_corr_lowest_nrm.ec",output=s//"_lowest_fl.ec",w1=INDEF,w2=INDEF,format="multispec",renumbe=no,offset=0,rebin=yes,errval=0,verbose=no,mode="h")	
				 }
	if(access(s//"_middown_fl.ec.fits")){print("FLATTED SPECTRUM ",s//"_middown_fl.ec"," ALREADY EXISTS, IT IS NOT OVERWRITTEN!")}	
				else
				 {	
	sarith(input1=s//"_middown.ec",op="/",input2="tmp_flat_corr_middown_nrm.ec",output=s//"_middown_fl.ec",w1=INDEF,w2=INDEF,format="multispec",renumbe=no,offset=0,rebin=yes,errval=0,verbose=no,mode="h")	
				 }
	if(access(s//"_midup_fl.ec.fits")){print("FLATTED SPECTRUM ",s//"_midup_fl.ec"," ALREADY EXISTS, IT IS NOT OVERWRITTEN!")}	
				else
				 {	
	sarith(input1=s//"_midup.ec",op="/",input2="tmp_flat_corr_midup_nrm.ec",output=s//"_midup_fl.ec",w1=INDEF,w2=INDEF,format="multispec",renumbe=no,offset=0,rebin=yes,errval=0,verbose=no,mode="h")	
				 }
	if(access(s//"_topmost_fl.ec.fits")){print("FLATTED SPECTRUM ",s//"_topmost_fl.ec"," ALREADY EXISTS, IT IS NOT OVERWRITTEN!")}	
				else
				 {	
	sarith(input1=s//"_topmost.ec",op="/",input2="tmp_flat_corr_topmost_nrm.ec",output=s//"_topmost_fl.ec",w1=INDEF,w2=INDEF,format="multispec",renumbe=no,offset=0,rebin=yes,errval=0,verbose=no,mode="h")	
				 }
				 }
				 }
				 }
	if(del1d==yes){
	imdelete("tmp_flat_corr_lowest_nrm.ec")
	imdelete("tmp_flat_corr_middown_nrm.ec")
	imdelete("tmp_flat_corr_midup_nrm.ec")
	imdelete("tmp_flat_corr_topmost_nrm.ec")
	}
end
