#
#
#	giano_find_trace.cl: 
#	extract traces after correcting for scattered light!
#	
##############################################################

procedure giano_find_trace (input_frame,out_frame,save_sc,interac_fit,displine,gnsum,gminsep,gmaxsep)

string input_frame      {prompt='Frame to use as a reference to extract traces:'}
string out_frame     {prompt='Output frame after scattered light removal:'}
bool save_sc=no        {prompt='Save scattered light map?'}
bool interac_fit=yes       {prompt='Fit traces interactively?'}
int  displine=1000          {prompt='Dispersion line:'}
int  gnsum=10              {prompt='Number of dispersion lines to sum or median:'}
real gminsep=3            {prompt='Minimum separation between spectra:'}
real gmaxsep=52          {prompt='Maximum separation between spectra:'}

begin
int i,mm
int ki
string output_map
string s
			


#  STEP 1: derive a scattered light map through fit1d
		print(" ")
		print(" ")
		print("Computing scattered light correction, PLEASE WAIT ...")
		print(" ")
		print(" ")
		print(" ")
	fit1d(input=input_frame,output=out_frame,axis=2,type="difference",interac=no,functio="spline3",order=2,low_rej=4.,high_re=2,niterat=30,grow=0)
  if(save_sc==yes){
	mm=0
	i=1
      while(mm==0){
		if(access("scatt_"//i//"_"//input_frame)){i=i+1}
			else
		{output_map="scatmap_"//i//"_"//input_frame
			mm=1
		print("**************************************************")	
		print(" ")
		print(" ")
		print("MAP OF SCATTERED LIGHT SAVED AS")
		print(output_map)
		print(" ")
		print(" ")
			}
		}
	fit1d(input=input_frame,output=output_map,axis=2,type="fit",interac=no,functio="spline3",order=2,low_rej=4.,high_re=2,niterat=30,grow=0,mode="h")
		}
#
#		Now use imreplace to delete part of orders 81-82, which
#		otherwise may interfere with apfind!
#
	imreplace(images=out_frame//"[800:1100,1988:2048]",value=0,lower=INDEF,upper=INDEF)
#
#
#		STEP 2
# 		Find traces using apfind
#
	apfind(input=out_frame,apertur=196,referen=" ",interac=interac_fit,find=yes,recente=yes,resize=no,edit=yes,line=displine,nsum=gnsum,nfind=196,minsep=gminsep,maxsep=gmaxsep,order="increasing",mode="h")
end
